//
//  NSDate+MCAdditions.h
//  MCFoundation
//
//  Created by Kevin Hiscott on 09-12-09.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSDate (MCAdditions)

#pragma mark Adding Conveniences
- (NSDate *)mcDateByAddingDays:(int)days;

#pragma mark Comparision Methods
- (BOOL)mcAreDateComponents:(unsigned int)components sameAsDate:(NSDate*)other;

- (BOOL)mcIsToday;
- (BOOL)mcIsYesterday;
- (BOOL)mcIsTomorrow;

- (BOOL)mcIsSameDayAsDate:(NSDate *)otherDate;

#pragma mark -
#pragma mark Date and Time Format
- (NSString *)mcShortTime;

- (NSString *)mcMediumDateTime;
- (NSString *)mcMediumDateTimeRelative;

// Relative Conveniences
- (NSString *)mcRelativeDateString; // returns nil if the day is neither Yesterday, Today or Tomorrow

- (NSInteger)mcDaysSinceDate:(NSDate *)date;

@end
